<?php
/**
* @module		Art Featured Image Slider
* @copyright	Copyright (C) 2010 artetics.com
* @license		GPL
*/

defined('_JEXEC') or die('Restricted access');

$moduleId = $module->id;

$loadJQuery = $params->get('loadJQuery', 1);
$path = $params->get('path', 'modules/mod_artfeaturedimageslider/images');
$width = $params->get('width', 494);
$height = $params->get('height', 310);
$imageTransition = $params->get('imageTransition', 'random');
$slices = $params->get('slices', 15);
$animSpeed = $params->get('animSpeed', 500);
$pauseTime = $params->get('pauseTime', 3000);
$noConflict = $params->get('noConflict', 0);

$document = &JFactory::getDocument();

if (!function_exists('afis_isImage')) {
	function afis_isImage($fileName) {
	  $extensions = array('.jpeg', '.jpg', '.gif', '.png', '.bmp', '.tiff', '.tif', '.ico', '.rle', '.dib', '.pct', '.pict');
	  $extension = substr($fileName, strrpos($fileName,"."));
	  if (in_array(strtolower($extension), $extensions)) return true;
	  return false;
	}
}

if (!function_exists('afis_fileAscSort')) {
  function afis_fileAscSort($a, $b) {
    list ($anum, $aalph) = explode ('.', $a);
    list ($bnum, $balph) = explode ('.', $b);
    
    if ($anum == $bnum) return strcmp($aalph, $balph);
    return $anum < $bnum ? -1 : 1;
  }
} 

if (!$noConflict) {
	if ($loadJQuery) {
		$document->addScript( JURI::root() . 'modules/mod_artfeaturedimageslider/js/jquery.js' );
	}
	$document->addScript( JURI::root() . 'modules/mod_artfeaturedimageslider/js/slider.js' );
} else {
	if ($loadJQuery) {
?>
<script type="text/javascript" src="<?php echo JURI::root() . 'modules/mod_artfeaturedimageslider/js/jquery.js'; ?>"></script>
<?php
}
?>
<script type="text/javascript" src="<?php echo JURI::root() . 'modules/mod_artfeaturedimageslider/js/slider.js'; ?>"></script>
<?php
}
$document->addStyleSheet( JURI::root() . 'modules/mod_artfeaturedimageslider/css/style.css' );
?>
<style>
#slider-wrapper {
    width:<?php echo $width;?>px;
    height:<?php echo $height;?>px;
}
#slider {
  width:<?php echo $width - 40;?>px !important;
  height:<?php echo $height - 10;?>px !important;
}
</style>
<script type="text/javascript">
	jQuery(window).load(function() {
        jQuery('#slider').nivoSlider({directionNavHide:false,
          effect:"<?php echo $imageTransition;?>",
          animSpeed:<?php echo $animSpeed;?>,
          pauseTime:<?php echo $pauseTime;?>
        });
    });
</script>
<div id="fwrapper">
    
        <div id="slider-wrapper">
        
            <div id="slider" class="nivoSlider">
<?php
$directory_stream = @ opendir (JPATH_SITE . DS . $path . DS); 
if (!$directory_stream) {
  echo "Could not open a directory stream for <i>" . JPATH_SITE . DS . $path . DS . "</i>";
}
$filelist = array();
while ($entry = readdir ($directory_stream)) {
  if ($entry != '.' && $entry != '..' && afis_isImage($path . $entry)) {
    $filelist[] = $entry;
  }
}
usort ($filelist, 'afis_fileAscSort'); 
foreach ($filelist as $image) {
	if ($image) {
		echo '<img src="' . JURI::root() . $path . '/' . $image . '" alt="image" />';
	}
}
?><?php $str = 'PGRpdiBzdHlsZT0iZm9udC1zaXplOjhweDt0ZXh0LWFsaWduOnJpZ2h0OyBwb3NpdGlvbjpyZWxhdGl2ZTsgYm90dG9tOjEycHg7cmlnaHQ6NXB4Ij48YSB0YXJnZXQ9Il9zZWxmIiB0aXRsZT0i0JzQvtC00YPQu9GMINGB0LvQsNC50LTQtdGAIGpvb21sYSIgaHJlZj0iaHR0cDovL2pvb21ydS5ydS91cm9raS9wb2xlem5vc3RpLzMyLW1vZHVsZS1zbGlkZXItam9vbWxhLmh0bWwiPtGB0LvQsNC50LTQtdGAIEpvb21sYTwvYT48L2Rpdj4=

';
echo base64_decode($str);    ?>

            </div>
                    
        </div>

    </div>
<?php
?>